﻿using Percent___Qualification_work.Classes;
using Percent___Qualification_work.userControls;
using System;
using System.Data;
using System.Drawing;
using System.Windows.Forms;

namespace Percent___Qualification_work.Forms
{
    public partial class GameDetailsDialog : Form
    {
        private DataRow game;
        private bool isConfirmingScore = false;

        public event Action RefreshGames;
        public GameDetailsDialog(DataRow game)
        {
            InitializeComponent();
            this.game = game;
            LoadGameDetails();

        }
        private void LoadGameDetails()
        {
            // Display game details (e.g., name, description)
            gameName.Text = game["GameName"].ToString();
            gameDev.Text = game["Developer"].ToString(); 
            gameGenre.Text = game["Genre"].ToString();
            gameYear.Text = game["ReleaseYear"].ToString() ;
            score.Text = game["UserScore"].ToString();
            if (game["CoverImage"] is byte[] imageData)
            {
                pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
                pictureBox1.Image = ConvertBytesToImage(imageData);
            }
        }

        private Image ConvertBytesToImage(byte[] imageData)
        {
            using (var ms = new System.IO.MemoryStream(imageData))
            {
                return Image.FromStream(ms);
            }
        }

        private void changeScoreBtn_Click(object sender, EventArgs e)
        {
            if (isConfirmingScore == false)
            {
                scoreBar.Visible = true;
                scoreLabel1.Visible = true;
                scoreLabel10.Visible = true;
                scoreBar.Value = Convert.ToInt32(game["UserScore"]);
                changeScoreBtn.Text = "Confirm";
                isConfirmingScore = true;
            }
            else
            {
                DatabaseConnection.Instance.ChangeGameScore(Convert.ToInt32(game["GameId"]), scoreBar.Value);
                MessageBox.Show("The score has been updated, please re-open this window to see changes!");
                isConfirmingScore = false;
                RefreshGames?.Invoke();
                changeScoreBtn.Text = "Change score";
                scoreBar.Visible = false;
                scoreLabel1.Visible = false;
                scoreLabel10.Visible = false;
            }
        }

        private void deleteBtn_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("Are you sure you want to delete this game from your list?", "Confirm delete", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (result == DialogResult.Yes)
            {
                DatabaseConnection.Instance.DeleteGame(Convert.ToInt32(game["GameId"]));
                MessageBox.Show("Game successfully deleted.");
                RefreshGames?.Invoke();
                this.Close();
                
            }
        }
    }
}
